/*
 * Decompiled with CFR 0.152.
 */
package mondo.engine;

import mondo.engine.Tokenizer;
import mondo.token.IClose;
import mondo.token.IOpen;
import mondo.token.NumberToken;
import mondo.token.SymbolToken;
import mondo.token.Token;
import mondo.token.WhiteSpaceToken;

public class Helper {
    private void addNullBetweenSemicolonAndBracketClose(Tokenizer tokenizer) {
        Token token = tokenizer.hardReset();
        while (token != null) {
            Token token2;
            if (token.getOriginalText() != null && token.getOriginalText().equals(";") && ((token2 = tokenizer.getNextNotBlank()) == null || token2 instanceof IClose)) {
                tokenizer.resetToThis();
                tokenizer.insertAfter(new SymbolToken().setOriginalText("null"));
            }
            token = tokenizer.hardNext();
        }
    }

    private void removeComaBeforeBracketClose(Tokenizer tokenizer) {
        Token token = tokenizer.hardReset();
        while (token != null) {
            Token token2;
            if (token.getOriginalText() != null && token.getOriginalText().equals(",") && ((token2 = tokenizer.getNextNotBlank()) == null || token2 instanceof IClose)) {
                tokenizer.resetToThis();
                tokenizer.replaceToken(new WhiteSpaceToken().setOriginalText(""));
            }
            token = tokenizer.hardNext();
        }
    }

    private void addZeroBeforeMinus(Tokenizer tokenizer) {
        Token token = tokenizer.hardReset();
        while (token != null) {
            Token token2;
            if (token.getOriginalText().equals("-") && ((token2 = tokenizer.getPreviousNotBlank()) == null || token2 instanceof IOpen || token2.isDelimiter())) {
                tokenizer.insertAfter(new NumberToken().setText("0"));
            }
            token = tokenizer.hardNext();
        }
    }

    public Helper(Tokenizer tokenizer) {
        this.addZeroBeforeMinus(tokenizer);
        this.addNullBetweenSemicolonAndBracketClose(tokenizer);
        this.removeComaBeforeBracketClose(tokenizer);
    }
}

