/*
 * Decompiled with CFR 0.152.
 */
package mondo.engine;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import mondo.engine.Helper;
import mondo.engine.Tokenizer;
import mondo.engine.Validator;
import mondo.invalidToken.InvalidTokenException;
import mondo.token.Token;

public class Parser {
    private List<String> lines;
    private String filename;
    private String outFilename;
    private Tokenizer tokenizer;

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    protected String getOutputFileName() {
        return this.outFilename == null ? this.filename + ".js" : this.outFilename;
    }

    private void readFromFile() throws IOException {
        Path path = Paths.get(this.filename, new String[0]);
        Charset charset = Charset.forName("UTF-8");
        try {
            this.lines = Files.readAllLines(path, charset);
            if (this.lines.size() < 1) {
                this.lines.add("null");
            }
        }
        catch (IOException iOException) {
            throw new IOException("File " + this.filename + " does not exist.");
        }
    }

    private void writeToFile() throws IOException {
        this.writeToFile(this.tokenizer.getTokens());
    }

    private void writeToFile(List<Token> list) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getOutputFileName()), "utf-8"));){
            for (Token token : list) {
                bufferedWriter.write(token.getText());
            }
        }
    }

    private void preConvert() {
        Token token = this.tokenizer.hardReset();
        while (token != null) {
            token.preConvert(this.tokenizer);
            token = this.tokenizer.hardNext();
        }
    }

    private void convert() {
        Token token = this.tokenizer.hardReset();
        while (token != null) {
            token.convert(this.tokenizer);
            token = this.tokenizer.hardNext();
        }
    }

    private void eventuallyChangeTokenType(Tokenizer tokenizer) {
        tokenizer.hardReset();
        List<Token> list = tokenizer.getTokens();
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, list.get(i).eventuallyChangeType(tokenizer));
            tokenizer.hardNext();
        }
    }

    public Parser(String string) throws IOException {
        this(string, null);
    }

    public Parser(String string, String string2) throws IOException {
        this.filename = string;
        this.outFilename = string2;
        try {
            this.readFromFile();
            this.tokenizer = new Tokenizer(new File(string), this.lines);
            this.eventuallyChangeTokenType(this.tokenizer);
            new Validator(this.tokenizer);
            new Helper(this.tokenizer);
            this.preConvert();
            this.convert();
            this.writeToFile();
        }
        catch (InvalidTokenException invalidTokenException) {
            this.writeToFile(invalidTokenException.getTokens());
        }
    }
}

