/*
 * Decompiled with CFR 0.152.
 */
package mondo.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mondo.invalidToken.InvalidTokenException;
import mondo.invalidToken.NonExistentTokenException;
import mondo.token.AbstractTokenizer;
import mondo.token.BracketToken;
import mondo.token.ClassFieldToken;
import mondo.token.CommentToken;
import mondo.token.DeclarationToken;
import mondo.token.MultiLineCommentToken;
import mondo.token.NewLineToken;
import mondo.token.NumberToken;
import mondo.token.ObjectFieldToken;
import mondo.token.OperatorToken;
import mondo.token.RegexToken;
import mondo.token.StringToken;
import mondo.token.SymbolToken;
import mondo.token.Token;
import mondo.token.WhiteSpaceToken;

public class Tokenizer
extends AbstractTokenizer {
    private List<Token> tokenTypes = new ArrayList<Token>(){
        {
            this.add(new CommentToken());
            this.add(new MultiLineCommentToken());
            this.add(new RegexToken());
            this.add(new BracketToken());
            this.add(new NumberToken());
            this.add(new DeclarationToken());
            this.add(new ClassFieldToken());
            this.add(new ObjectFieldToken());
            this.add(new WhiteSpaceToken());
            this.add(new OperatorToken());
            this.add(new SymbolToken());
            this.add(new StringToken());
        }
    };
    private List<Token> tokens = new ArrayList<Token>();
    private int hardTokenIndex = 0;
    private int tokenIndex = 0;

    Token hardNext() {
        ++this.hardTokenIndex;
        this.tokenIndex = this.hardTokenIndex;
        if (this.tokenIndex < this.tokens.size()) {
            return this.tokens.get(this.tokenIndex);
        }
        return null;
    }

    public Token hardReset() {
        this.finished = false;
        this.tokenIndex = this.hardTokenIndex = 0;
        if (this.tokens.size() < 1) {
            return null;
        }
        return this.tokens.get(this.tokenIndex);
    }

    @Override
    public Token reset() {
        this.tokenIndex = 0;
        if (this.tokens.size() < 1) {
            return null;
        }
        return this.tokens.get(this.tokenIndex);
    }

    @Override
    public Token resetToThis() {
        this.tokenIndex = this.hardTokenIndex;
        return this.tokens.get(this.tokenIndex);
    }

    @Override
    public Token getCurrent() {
        if (this.tokenIndex < this.tokens.size()) {
            return this.tokens.get(this.tokenIndex);
        }
        return null;
    }

    @Override
    public Token getNext() {
        ++this.tokenIndex;
        if (this.tokenIndex < this.tokens.size()) {
            return this.tokens.get(this.tokenIndex);
        }
        return null;
    }

    @Override
    public Token getPrevious() {
        --this.tokenIndex;
        if (this.tokenIndex >= 0) {
            return this.tokens.get(this.tokenIndex);
        }
        return null;
    }

    @Override
    public void insertAfter(Token token) {
        this.tokens.add(this.tokenIndex + 1, token);
        if (this.tokenIndex + 1 <= this.hardTokenIndex) {
            ++this.hardTokenIndex;
        }
        ++this.tokenIndex;
    }

    @Override
    public List<Token> getTokens() {
        return this.tokens;
    }

    @Override
    public void replaceToken(Token token) {
        this.tokens.set(this.tokenIndex, token);
    }

    public Tokenizer(File file, List<String> list) throws InvalidTokenException {
        Token.setStaticFilename(file.getAbsolutePath());
        for (int i = 0; i < list.size(); ++i) {
            int n = 0;
            while (n < list.get(i).length()) {
                int n2 = n;
                for (Token token : this.tokenTypes) {
                    Token token2 = token.setFile(file).find(this.tokens.size() > 0 ? this.tokens.get(this.tokens.size() - 1) : null, list, i, n);
                    if (token2 == null) continue;
                    n = token2.getEndX() + 1;
                    i = token2.getEndLineNr();
                    this.tokens.add(token2);
                    break;
                }
                if (n2 != n) continue;
                throw InvalidTokenException.create(NonExistentTokenException.class, file.getAbsolutePath(), i, n);
            }
            this.tokens.add(new NewLineToken(i, list.get(i).length()).setFile(file));
        }
    }
}

