/*
 * Decompiled with CFR 0.152.
 */
package mondo.engine;

import java.util.EmptyStackException;
import java.util.Stack;
import mondo.engine.Tokenizer;
import mondo.invalidToken.BracketStackException;
import mondo.invalidToken.InvalidTokenException;
import mondo.invalidToken.OperatorAfterBracketCloseException;
import mondo.invalidToken.OperatorAfterBracketOpenException;
import mondo.invalidToken.OperatorAfterOperatorException;
import mondo.invalidToken.OperatorBeforeBracketCloseException;
import mondo.invalidToken.ValueAfterValueException;
import mondo.token.BiOperatorToken;
import mondo.token.IClose;
import mondo.token.IOpen;
import mondo.token.Token;

public class Validator {
    private Tokenizer tokenizer;

    private void checkForOperatorAfterOperator() throws InvalidTokenException {
        Token token = this.tokenizer.hardReset();
        while (token != null) {
            Token token2 = this.tokenizer.getNextNotBlank();
            if (token2 == null) {
                return;
            }
            if (token instanceof BiOperatorToken && token2 instanceof BiOperatorToken && (!((BiOperatorToken)token).isArithmetic() || !((BiOperatorToken)token2).isAllowedAtBegin())) {
                throw InvalidTokenException.create(OperatorAfterOperatorException.class, token2.getFullFilename(), token2.getLineNr(), token2.getBegX());
            }
            token = token2;
        }
    }

    private void checkValueAfterValue() throws InvalidTokenException {
        Token token = this.tokenizer.hardReset();
        while (token != null) {
            Token token2 = this.tokenizer.getNextNotBlank();
            if (token2 == null) {
                return;
            }
            if (token.isEntity() && token2.isEntity()) {
                throw InvalidTokenException.create(ValueAfterValueException.class, token2.getFullFilename(), token2.getLineNr(), token2.getBegX());
            }
            token = token2;
        }
    }

    private void checkAfterBracketOpen() throws InvalidTokenException {
        Token token = this.tokenizer.hardReset();
        while (token != null) {
            Token token2 = this.tokenizer.getNextNotBlank();
            if (token2 == null) {
                return;
            }
            if (token instanceof IOpen && token2 instanceof BiOperatorToken && !((BiOperatorToken)token2).isAllowedAtBegin()) {
                throw InvalidTokenException.create(OperatorAfterBracketOpenException.class, token2.getFullFilename(), token2.getLineNr(), token2.getBegX());
            }
            token = token2;
        }
    }

    private void checkBeforeBracketClose() throws InvalidTokenException {
        Token token = this.tokenizer.hardReset();
        while (token != null) {
            Token token2 = this.tokenizer.getNextNotBlank();
            if (token2 == null) {
                return;
            }
            if (token instanceof BiOperatorToken && !token.isDelimiter() && token2 instanceof IClose) {
                throw InvalidTokenException.create(OperatorBeforeBracketCloseException.class, token2.getFullFilename(), token2.getLineNr(), token2.getBegX());
            }
            token = token2;
        }
    }

    private void checkAfterBracketClose() throws InvalidTokenException {
        Token token = this.tokenizer.hardReset();
        while (token != null) {
            Token token2 = this.tokenizer.getNextNotBlank();
            if (token2 == null) {
                return;
            }
            if (token instanceof IClose && token2.isEntity()) {
                throw InvalidTokenException.create(OperatorAfterBracketCloseException.class, token2.getFullFilename(), token2.getLineNr(), token2.getBegX());
            }
            token = token2;
        }
    }

    private void checkBracketStack() throws InvalidTokenException {
        Stack<Token> stack = new Stack<Token>();
        Token token = this.tokenizer.hardReset();
        while (token != null) {
            if (token instanceof IOpen) {
                stack.push(token);
            } else if (token instanceof IClose) {
                try {
                    Token token2 = (Token)stack.pop();
                    if (((IClose)((Object)token)).getOpenClass() != token2.getClass()) {
                        throw InvalidTokenException.create(BracketStackException.class, token.getFullFilename(), token.getLineNr(), token.getBegX(), "unexpected " + token.getOriginalText());
                    }
                }
                catch (EmptyStackException emptyStackException) {
                    throw InvalidTokenException.create(BracketStackException.class, token.getFullFilename(), token.getLineNr(), token.getBegX(), "empty bracket stack - unexpected " + token.getOriginalText());
                }
            }
            token = this.tokenizer.getNextNotBlank();
        }
        if (!stack.empty()) {
            token = this.tokenizer.getPrevious();
            throw InvalidTokenException.create(BracketStackException.class, token.getFullFilename(), token.getLineNr(), token.getBegX(), "not empty bracket stack at the end");
        }
    }

    public Validator(Tokenizer tokenizer) throws InvalidTokenException {
        this.tokenizer = tokenizer;
        this.checkForOperatorAfterOperator();
        this.checkValueAfterValue();
        this.checkBracketStack();
        this.checkAfterBracketOpen();
        this.checkBeforeBracketClose();
        this.checkAfterBracketClose();
    }
}

