/*
 * Decompiled with CFR 0.152.
 */
package mondo.token;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondo.token.IClose;
import mondo.token.IOpen;
import mondo.token.ITokenizer;
import mondo.token.SymbolToken;
import mondo.token.Token;

public abstract class AbstractTokenizer
implements ITokenizer {
    protected boolean finished;

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public abstract List<Token> getTokens();

    @Override
    public abstract Token resetToThis();

    @Override
    public abstract Token getCurrent();

    @Override
    public abstract Token getNext();

    @Override
    public abstract Token getPrevious();

    @Override
    public Token getNextNotBlank() {
        Token token = this.getNext();
        while (token != null) {
            if (!token.isBlank()) {
                return token;
            }
            token = this.getNext();
        }
        return null;
    }

    @Override
    public Token getPreviousNotBlank() {
        Token token = this.getPrevious();
        while (token != null) {
            if (!token.isBlank()) {
                return token;
            }
            token = this.getPrevious();
        }
        return null;
    }

    @Override
    public abstract void insertAfter(Token var1);

    @Override
    public void insertBefore(Token token) {
        this.getPrevious();
        this.insertAfter(token);
    }

    private static <T> void incrementMap(Map<T, Integer> map, T t) {
        if (map.containsKey(t)) {
            map.put(t, map.get(t) + 1);
        } else {
            map.put(t, 1);
        }
    }

    private static <T> void decrementMap(Map<T, Integer> map, T t) {
        if (map.containsKey(t)) {
            map.put(t, map.get(t) - 1);
        } else {
            map.put(t, -1);
        }
    }

    private static <T> boolean allEqualsZero(Map<T, Integer> map) {
        for (Integer n : map.values()) {
            if (n == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Token getNextAtSameBracketLevel() {
        HashMap hashMap = new HashMap();
        Token token = this.getCurrent();
        while (token != null) {
            if (token instanceof IOpen) {
                AbstractTokenizer.incrementMap(hashMap, token.getClass());
            } else if (token instanceof IClose) {
                AbstractTokenizer.decrementMap(hashMap, ((IClose)((Object)token)).getOpenClass());
            }
            if (AbstractTokenizer.allEqualsZero(hashMap)) {
                return this.getNextNotBlank();
            }
            token = this.getNextNotBlank();
        }
        return null;
    }

    @Override
    public Token getMatchingCloseBracket() {
        if (!(this.getCurrent() instanceof IOpen)) {
            return null;
        }
        Class<?> clazz = this.getCurrent().getClass();
        int n = 1;
        Token token = this.getNextNotBlank();
        while (token != null) {
            if (clazz.isInstance(token)) {
                ++n;
            }
            if (token instanceof IClose && ((IClose)((Object)token)).getOpenClass().equals(clazz)) {
                --n;
            }
            if (n == 0) {
                return token;
            }
            token = this.getNextNotBlank();
        }
        return null;
    }

    @Override
    public List<Token> getLastGroup() {
        int n = 0;
        ArrayList<Token> arrayList = new ArrayList<Token>();
        Token token = this.getCurrent();
        while (token != null) {
            arrayList.add((Token)token.clone());
            if (token instanceof IClose) {
                ++n;
            } else if (token instanceof IOpen) {
                --n;
            }
            if (n == 0) break;
            token = this.getPreviousNotBlank();
        }
        if ((token = this.getPreviousNotBlank()) instanceof SymbolToken) {
            arrayList.add((Token)token.clone());
        }
        Collections.reverse(arrayList);
        return arrayList;
    }
}

