/*
 * Decompiled with CFR 0.152.
 */
package mondo.token;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import mondo.token.BracketToken;
import mondo.token.IClose;
import mondo.token.ITokenizer;
import mondo.token.OperatorToken;
import mondo.token.Token;

public class BiOperatorToken
extends OperatorToken {
    private int order = -1;
    private static Set<String> delimiterTokens = new HashSet<String>(){
        {
            this.add(";");
            this.add(",");
        }
    };
    private static Set<String> tokensAllowedAtBegin = new HashSet<String>(){
        {
            this.add("+");
            this.add("-");
        }
    };
    private static Set<String> compositeOperators = new HashSet<String>(){
        {
            this.add("+=");
            this.add("-=");
            this.add("*=");
            this.add("/=");
            this.add("^=");
            this.add("&=");
            this.add("|=");
            this.add("%=");
            this.add(".=");
        }
    };
    private static Set<String> arithmeticTokens = new HashSet<String>(){
        {
            this.add("+");
            this.add("-");
            this.add("%");
            this.add("*");
            this.add("/");
            this.add("^");
            this.add(".");
        }
    };
    private static List<String> possibleTokens = new ArrayList<String>(){
        {
            this.add(";");
            this.add(",");
            this.add(":=");
            this.add("=");
            this.add("+=");
            this.add("-=");
            this.add("*=");
            this.add("/=");
            this.add("^=");
            this.add("&=");
            this.add("|=");
            this.add("%=");
            this.add(".=");
            this.add("~~");
            this.add("<->");
            this.add("<<");
            this.add(">>");
            this.add("?");
            this.add("|");
            this.add("&");
            this.add("<=>");
            this.add(">=");
            this.add(">");
            this.add("<=");
            this.add("<");
            this.add("!=");
            this.add("==");
            this.add("!==");
            this.add("===");
            this.add("=~");
            this.add("!~");
            this.add("+");
            this.add("-");
            this.add("%");
            this.add("*");
            this.add("/");
            this.add("^");
            this.add("^^");
            this.add(".");
            this.add("..");
            this.add(":");
        }
    };
    private static Map<String, Integer> operatorOrder = new TreeMap<String, Integer>();
    private static Map<String, Function<String, String>> functionMap;
    private List<String> operatorsToOverload = new ArrayList<String>(){
        {
            this.add("<<");
            this.add(">>");
            this.add("|");
            this.add("&");
            this.add("=~");
            this.add("!~");
            this.add("+");
            this.add("-");
            this.add("%");
            this.add("*");
            this.add("/");
            this.add("^");
            this.add("..");
            this.add(":");
            this.add("?");
        }
    };

    public BiOperatorToken setOrder(int n) {
        this.order = n;
        return this;
    }

    public int getOrder() {
        if (this.order != -1) {
            return this.order;
        }
        return operatorOrder.get(this.getOriginalText());
    }

    @Override
    protected List<String> getOnlyPossibleTokens() {
        return possibleTokens;
    }

    public boolean isArithmetic() {
        return arithmeticTokens.contains(this.originalText);
    }

    public boolean isAllowedAtBegin() {
        return tokensAllowedAtBegin.contains(this.originalText);
    }

    @Override
    public boolean isDelimiter() {
        return delimiterTokens.contains(this.getOriginalText());
    }

    private static int getOrderMaxNumber() {
        return possibleTokens.size() * 2;
    }

    @Override
    protected Map<String, Function<String, String>> getFunctionMap() {
        return functionMap;
    }

    void replaceComposeOperator(ITokenizer iTokenizer) {
        String string = iTokenizer.getCurrent().getOriginalText();
        string = string.substring(0, string.length() - 1);
        iTokenizer.getCurrent().setText("=");
        iTokenizer.getPreviousNotBlank();
        List<Token> list = iTokenizer.getLastGroup();
        iTokenizer.resetToThis();
        for (Token token : list) {
            iTokenizer.insertAfter(token);
        }
        iTokenizer.insertAfter(((BiOperatorToken)new BiOperatorToken().setOriginalText(string)).setOrder(this.getOrder()));
    }

    @Override
    public void preConvert(ITokenizer iTokenizer) {
        if (compositeOperators.contains(iTokenizer.getCurrent().getOriginalText())) {
            this.replaceComposeOperator(iTokenizer);
        }
    }

    @Override
    protected void matchOperatorMethod(ITokenizer iTokenizer) {
        if (!this.operatorsToOverload.contains(iTokenizer.getCurrent().getOriginalText())) {
            return;
        }
        Integer n = ((BiOperatorToken)iTokenizer.getCurrent()).getOrder();
        iTokenizer.getCurrent().setText("['" + iTokenizer.getCurrent().getOriginalText() + "'](");
        Token token = iTokenizer.getNextAtSameBracketLevel();
        while (token != null) {
            try {
                if (token instanceof IClose || token instanceof BiOperatorToken && ((BiOperatorToken)token).getOrder() <= n) {
                    iTokenizer.insertBefore(BracketToken.getOperatorBracketClose());
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                return;
            }
            token = iTokenizer.getNextAtSameBracketLevel();
        }
        iTokenizer.insertBefore(BracketToken.getOperatorBracketClose());
    }

    static {
        for (int i = 0; i < possibleTokens.size(); ++i) {
            operatorOrder.put(possibleTokens.get(i), i);
        }
        functionMap = new HashMap<String, Function<String, String>>(){};
    }
}

