/*
 * Decompiled with CFR 0.152.
 */
package mondo.token;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mondo.token.BracketCloseToken;
import mondo.token.BracketOpenToken;
import mondo.token.FunctionEndToken;
import mondo.token.FunctionToken;
import mondo.token.ITokenizer;
import mondo.token.IndexOperatorToken;
import mondo.token.NewLineToken;
import mondo.token.OperatorToken;
import mondo.token.SquareBracketCloseToken;
import mondo.token.SquareBracketOpenToken;
import mondo.token.SymbolToken;
import mondo.token.Token;

public class BracketToken
extends Token {
    private Token role;
    private Map<String, Function<ITokenizer, String>> functionMap = new HashMap<String, Function<ITokenizer, String>>(){
        {
            this.put("[", iTokenizer -> "[");
            this.put("]", iTokenizer -> "]");
            this.put("(", iTokenizer -> "(");
            this.put(")", iTokenizer -> ")");
            this.put("{", iTokenizer -> BracketToken.matchFunctionBegin(iTokenizer));
            this.put("}", BracketToken::matchFunctionEnd);
            this.put("$(", iTokenizer -> BracketToken.matchSet(iTokenizer));
            this.put("%(", iTokenizer -> BracketToken.matchAssociativeArray(iTokenizer));
            this.put("#(", iTokenizer -> BracketToken.matchDictionary(iTokenizer));
        }
    };
    private Map<String, Class<?>> classMap = new HashMap<String, Class<?>>(){
        {
            this.put("[", SquareBracketOpenToken.class);
            this.put("]", SquareBracketCloseToken.class);
            this.put("(", BracketOpenToken.class);
            this.put(")", BracketCloseToken.class);
            this.put("{", FunctionToken.class);
            this.put("}", FunctionEndToken.class);
            this.put("$(", BracketOpenToken.class);
            this.put("%(", BracketOpenToken.class);
            this.put("#(", BracketOpenToken.class);
        }
    };

    public BracketToken setRole(Token token) {
        this.role = token;
        return this;
    }

    public Token getRole() {
        return this.role;
    }

    @Override
    public boolean isBlank() {
        return false;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    static Token getOperatorBracketOpen() {
        return new BracketOpenToken().setText("(");
    }

    static Token getOperatorBracketClose() {
        return new BracketCloseToken().setText(")");
    }

    @Override
    protected List<String> getPossibleTokens() {
        return new ArrayList<String>(){
            {
                this.add("[");
                this.add("]");
                this.add("(");
                this.add(")");
                this.add("{");
                this.add("}");
                this.add("#(");
                this.add("$(");
                this.add("%(");
            }
        };
    }

    private static String matchSet(ITokenizer iTokenizer) {
        iTokenizer.getMatchingCloseBracket();
        iTokenizer.insertBefore(new BracketToken().setText("]"));
        return "new Set([";
    }

    private static String matchDictionary(ITokenizer iTokenizer) {
        return "new Dictionary(";
    }

    private static String matchAssociativeArray(ITokenizer iTokenizer) {
        return "new AssocArray(";
    }

    private static String matchFunctionBegin(ITokenizer iTokenizer) {
        return "(function () {";
    }

    public static String matchFunctionEnd(ITokenizer iTokenizer) {
        int n = 1;
        Token token = iTokenizer.getPreviousNotBlank();
        while (token != null) {
            if (token.getText() == OperatorToken.getOperatorSemicolon().getText()) {
                token.setText("; return ");
                break;
            }
            if (token instanceof FunctionToken) {
                --n;
            }
            if (token instanceof FunctionEndToken) {
                ++n;
            }
            if (n == 0) {
                iTokenizer.insertAfter(new SymbolToken().setText("return "));
                break;
            }
            token = iTokenizer.getPreviousNotBlank();
        }
        token = iTokenizer.getNext();
        while (token.isBlank()) {
            if (token instanceof NewLineToken) {
                token.setText(" ");
            }
            token = iTokenizer.getNext();
        }
        return "})";
    }

    @Override
    protected void doConvert(ITokenizer iTokenizer) {
        try {
            this.text = this.functionMap.get(this.originalText).apply(iTokenizer);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public Token eventuallyChangeType(ITokenizer iTokenizer) {
        Token token = iTokenizer.getPrevious();
        if (this.originalText.equals("[") && token != null && token.isEntity()) {
            this.setRole(new IndexOperatorToken());
        }
        if (this.classMap.containsKey(this.originalText)) {
            try {
                Token token2 = ((Token)this.classMap.get(this.originalText).newInstance()).copyAll(this);
                return token2;
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
        return this;
    }
}

