/*
 * Decompiled with CFR 0.152.
 */
package mondo.token;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mondo.token.BiOperatorToken;
import mondo.token.ITokenizer;
import mondo.token.Token;
import mondo.token.UniOperatorToken;

public class OperatorToken
extends Token {
    private static List<OperatorToken> activeSubtypes = new ArrayList<OperatorToken>(){
        {
            this.add(new BiOperatorToken());
            this.add(new UniOperatorToken());
        }
    };
    private static List<String> possibleTokens = new ArrayList<String>();

    @Override
    public boolean isBlank() {
        return false;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    static Token getOperatorDot() {
        return new OperatorToken().setText(".");
    }

    static Token getOperatorSemicolon() {
        return new OperatorToken().setText(";");
    }

    @Override
    protected List<String> getPossibleTokens() {
        return possibleTokens;
    }

    protected List<String> getOnlyPossibleTokens() {
        return new ArrayList<String>();
    }

    protected Map<String, Function<String, String>> getFunctionMap() {
        return new HashMap<String, Function<String, String>>();
    }

    protected void matchOperatorMethod(ITokenizer iTokenizer) {
    }

    @Override
    protected void doConvert(ITokenizer iTokenizer) {
        try {
            this.text = this.getFunctionMap().get(this.originalText).apply(this.originalText);
        }
        catch (NullPointerException nullPointerException) {
            this.matchOperatorMethod(iTokenizer);
        }
    }

    @Override
    public Token getObjectOfSuitableSubclass(String string) {
        for (OperatorToken operatorToken : activeSubtypes) {
            if (!operatorToken.getOnlyPossibleTokens().contains(string)) continue;
            return (Token)operatorToken.clone();
        }
        return new OperatorToken();
    }

    static {
        for (OperatorToken operatorToken : activeSubtypes) {
            possibleTokens.addAll(operatorToken.getOnlyPossibleTokens());
        }
    }
}

