/*
 * Decompiled with CFR 0.152.
 */
package mondo.token;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mondo.token.BracketToken;
import mondo.token.IClose;
import mondo.token.ITokenizer;
import mondo.token.OperatorToken;
import mondo.token.SquareBracketOpenToken;
import mondo.token.Token;

public class SymbolToken
extends Token {
    private Map<String, Function<String, String>> functionMap = new HashMap<String, Function<String, String>>(){
        {
            this.put("args", string -> "([this].concat(Array.prototype.slice.call(arguments)))");
            this.put("this", string -> "this");
            this.put("first", string -> "arguments[0]");
            this.put("second", string -> "arguments[1]");
            this.put("third", string -> "arguments[2]");
            this.put("rand", string -> "Math.random()");
            this.put("null", string -> "new Null()");
        }
    };
    private Map<String, Function<Token, String>> tokenFunctionMap = new HashMap<String, Function<Token, String>>(){
        {
            this.put("__line__", token -> "(" + token.getLineNr() + ")");
            this.put("__pos__", token -> "(" + token.getBegX() + ")");
            this.put("__file__", token -> "\"" + token.getFilename() + "\"");
            this.put("__dir__", token -> "\"" + token.getDirName() + "\"");
        }
    };

    @Override
    public boolean isBlank() {
        return false;
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    @Override
    public String getRegex() {
        return "[A-Za-z_]+[A-Za-z_0-9]*";
    }

    private boolean insertBracketAfterEventually(ITokenizer iTokenizer) {
        iTokenizer.resetToThis();
        Token token = iTokenizer.getPreviousNotBlank();
        if (token == null || !token.getText().equals(OperatorToken.getOperatorDot().getText())) {
            return false;
        }
        iTokenizer.resetToThis();
        Token token2 = iTokenizer.getNextNotBlank();
        if (!(token2 == null || token2 instanceof OperatorToken || token2 instanceof IClose || token2 instanceof SquareBracketOpenToken)) {
            return false;
        }
        iTokenizer.resetToThis();
        iTokenizer.insertAfter(BracketToken.getOperatorBracketOpen());
        iTokenizer.insertAfter(BracketToken.getOperatorBracketClose());
        return true;
    }

    @Override
    protected void doConvert(ITokenizer iTokenizer) {
        this.insertBracketAfterEventually(iTokenizer);
        iTokenizer.resetToThis();
        Token token = iTokenizer.getPreviousNotBlank();
        if (token != null && token.getOriginalText() == ".") {
            return;
        }
        try {
            this.text = this.functionMap.get(this.originalText).apply(this.originalText);
        }
        catch (NullPointerException nullPointerException) {
            try {
                this.text = this.tokenFunctionMap.get(this.originalText).apply(this);
            }
            catch (NullPointerException nullPointerException2) {
                // empty catch block
            }
        }
    }
}

