/*
 * Decompiled with CFR 0.152.
 */
package mondo.token;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondo.token.BracketToken;
import mondo.token.FunctionEndToken;
import mondo.token.FunctionToken;
import mondo.token.ITokenizer;

public abstract class Token
implements Cloneable {
    private static String staticFilename;
    protected String originalText;
    protected String text;
    protected File file;
    protected int lineNr;
    protected int begX;
    protected int endX;

    public abstract boolean isBlank();

    public static void setStaticFilename(String string) {
        staticFilename = string;
    }

    public boolean isEntity() {
        if (this.isBlank()) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    public boolean isDelimiter() {
        return false;
    }

    protected String getRegex() {
        throw new UnsupportedOperationException();
    }

    protected List<String> getPossibleTokens() {
        throw new UnsupportedOperationException();
    }

    public void preConvert(ITokenizer iTokenizer) {
    }

    public final void convert(ITokenizer iTokenizer) {
        if (iTokenizer.isFinished()) {
            return;
        }
        if (this.getOriginalText() != null && this.getText().equals(this.getOriginalText())) {
            this.doConvert(iTokenizer);
        }
        iTokenizer.resetToThis();
        if (iTokenizer.getNext() == null) {
            iTokenizer.resetToThis();
            iTokenizer.insertAfter(new FunctionEndToken().setText("})[typeof module !== 'undefined' ? 'exports' : 'call'](typeof module !== 'undefined' ? module : null)"));
            iTokenizer.reset();
            iTokenizer.insertBefore(new FunctionToken().setText("(function() {"));
            iTokenizer.resetToThis();
            BracketToken.matchFunctionEnd(iTokenizer);
            iTokenizer.finish();
        }
    }

    protected void doConvert(ITokenizer iTokenizer) {
    }

    public Token eventuallyChangeType(ITokenizer iTokenizer) {
        return this;
    }

    public String getFullFilename() {
        if (this.file != null) {
            return this.getDirName() + this.getFilename();
        }
        return staticFilename;
    }

    public String getFilename() {
        return this.file.getName();
    }

    public String getDirName() {
        return this.file.getParentFile().getAbsolutePath();
    }

    public Token setFile(File file) {
        this.file = file;
        return this;
    }

    public int getBegX() {
        return this.begX;
    }

    public Token setBegX(int n) {
        this.begX = n;
        return this;
    }

    public int getEndX() {
        return this.endX;
    }

    public Token setEndX(int n) {
        this.endX = n;
        return this;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public String getText() {
        return this.text;
    }

    public Token setOriginalText(String string) {
        this.originalText = string;
        this.text = string;
        return this;
    }

    public Token setText(String string) {
        this.text = string;
        return this;
    }

    public Pattern getPattern() {
        return Pattern.compile(this.getRegex());
    }

    protected boolean isPossibleAfterPrevious(Token token) {
        return true;
    }

    public Token find(Token token, List<String> list, int n, int n2) {
        if (!this.isPossibleAfterPrevious(token)) {
            return null;
        }
        try {
            return this.findFromRegex(list, n, n2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return this.findFromList(list, n, n2);
        }
    }

    protected Token findFromList(List<String> list, int n, int n2) {
        Token token = null;
        for (String string : this.getPossibleTokens()) {
            if (token != null && string.length() <= token.getOriginalText().length() || list.get(n).indexOf(string, n2) != n2) continue;
            token = this.getObjectOfSuitableSubclass(string).setBegX(n2).setEndX(n2 + string.length() - 1).setOriginalText(string).setText(string).setLineNr(n);
        }
        return token;
    }

    protected Token findFromRegex(List<String> list, int n, int n2) {
        Matcher matcher = this.getPattern().matcher(list.get(n));
        boolean bl = matcher.find(n2);
        if (bl && matcher.start() == n2) {
            String string = list.get(n).substring(matcher.start(), matcher.end());
            Token token = this.getObjectOfSuitableSubclass(string).setBegX(matcher.start()).setEndX(matcher.end() - 1).setOriginalText(string).setText(string).setLineNr(n);
            return token;
        }
        return null;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public Token setLineNr(int n) {
        this.lineNr = n;
        return this;
    }

    public int getEndLineNr() {
        return this.getLineNr();
    }

    public String toString() {
        return "Token {lineNr: " + this.lineNr + ", " + "begX: " + this.begX + ", " + "endX: " + this.endX + ", " + "type: \"" + this.getClass().getSimpleName() + "\", " + "originalText: \"" + this.originalText + "\", " + "text: \"" + this.text + "\"" + "}";
    }

    public Token getObjectOfSuitableSubclass(String string) {
        return (Token)this.clone();
    }

    public Token copyAll(Token token) {
        this.setBegX(token.begX);
        this.setEndX(token.endX);
        this.setLineNr(token.lineNr);
        this.setOriginalText(token.originalText);
        this.setText(token.text);
        this.setFile(token.file);
        return this;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

